struct optcode opt_table[] = {
  { "ADC A,A", 0x8f, 0, 0, 0 },
  { "ADC A,B", 0x88, 0, 0, 0 },
  { "ADC A,C", 0x89, 0, 0, 0 },
  { "ADC A,D", 0x8a, 0, 0, 0 },
  { "ADC A,E", 0x8b, 0, 0, 0 },
  { "ADC A,H", 0x8c, 0, 0, 0 },
  { "ADC A,(HL)", 0x8e, 0, 0, 0 },
  { "ADC A,IXH", 0x8cdd, 3, 0, 0 },
  { "ADC A,IXL", 0x8ddd, 3, 0, 0 },
  { "ADC A,(IXs)", 0x8edd, 4, 0, 0 },
  { "ADC A,IYH", 0x8cfd, 3, 0, 0 },
  { "ADC A,IYL", 0x8dfd, 3, 0, 0 },
  { "ADC A,(IYs)", 0x8efd, 4, 0, 0 },
  { "ADC A,L", 0x8d, 0, 0, 0 },
  { "ADC A,x", 0xce, 1, 0, 0 },
  { "ADC HL,BC", 0x4aed, 3, 0, 0 },
  { "ADC HL,DE", 0x5aed, 3, 0, 0 },
  { "ADC HL,HL", 0x6aed, 3, 0, 0 },
  { "ADC HL,SP", 0x7aed, 3, 0, 0 },

  { "ADD A,A", 0x87, 0, 0, 0 },
  { "ADD A,B", 0x80, 0, 0, 0 },
  { "ADD A,C", 0x81, 0, 0, 0 },
  { "ADD A,D", 0x82, 0, 0, 0 },
  { "ADD A,E", 0x83, 0, 0, 0 },
  { "ADD A,H", 0x84, 0, 0, 0 },
  { "ADD A,(HL)", 0x86, 0, 0, 0 },
  { "ADD A,IXH", 0x84dd, 3, 0, 0 },
  { "ADD A,IXL", 0x85dd, 3, 0, 0 },
  { "ADD A,(IXs)", 0x86dd, 4, 0, 0 },
  { "ADD A,IYH", 0x84fd, 3, 0, 0 },
  { "ADD A,IYL", 0x85fd, 3, 0, 0 },
  { "ADD A,(IYs)", 0x86fd, 4, 0, 0 },
  { "ADD A,L", 0x85, 0, 0, 0 },
  { "ADD A,x", 0xc6, 1, 0, 0 },
  { "ADD HL,BC", 0x9, 0, 0, 0 },
  { "ADD HL,DE", 0x19, 0, 0, 0 },
  { "ADD HL,HL", 0x29, 0, 0, 0 },
  { "ADD HL,SP", 0x39, 0, 0, 0 },
  { "ADD IX,BC", 0x9dd, 3, 0, 0 },
  { "ADD IX,DE", 0x19dd, 3, 0, 0 },
  { "ADD IX,IX", 0x29dd, 3, 0, 0 },
  { "ADD IX,SP", 0x39dd, 3, 0, 0 },
  { "ADD IY,BC", 0x9fd, 3, 0, 0 },
  { "ADD IY,DE", 0x19fd, 3, 0, 0 },
  { "ADD IY,IY", 0x29fd, 3, 0, 0 },
  { "ADD IY,SP", 0x39fd, 3, 0, 0 },

  { "AND A", 0xa7, 0, 0, 0 },
  { "AND B", 0xa0, 0, 0, 0 },
  { "AND C", 0xa1, 0, 0, 0 },
  { "AND D", 0xa2, 0, 0, 0 },
  { "AND E", 0xa3, 0, 0, 0 },
  { "AND H", 0xa4, 0, 0, 0 },
  { "AND (HL)", 0xa6, 0, 0, 0 },
  { "AND IXH", 0xa4dd, 3, 0, 0 },
  { "AND IXL", 0xa5dd, 3, 0, 0 },
  { "AND (IXs)", 0xa6dd, 4, 0, 0 },
  { "AND IYH", 0xa4fd, 3, 0, 0 },
  { "AND IYL", 0xa5fd, 3, 0, 0 },
  { "AND (IYs)", 0xa6fd, 4, 0, 0 },
  { "AND L", 0xa5, 0, 0, 0 },
  { "AND x", 0xe6, 1, 0, 0 },

  { "BIT *,A", 0x47cb, 9, 0, 0 },
  { "BIT *,B", 0x40cb, 9, 0, 0 },
  { "BIT *,C", 0x41cb, 9, 0, 0 },
  { "BIT *,D", 0x42cb, 9, 0, 0 },
  { "BIT *,E", 0x43cb, 9, 0, 0 },
  { "BIT *,H", 0x44cb, 9, 0, 0 },
  { "BIT *,(HL)", 0x46cb, 9, 0, 0 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x46, 0 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x46, 0 },
  { "BIT *,L", 0x45cb, 9, 0, 0 },
  { "BIT *,A", 0x4fcb, 9, 0, 1 },
  { "BIT *,B", 0x48cb, 9, 0, 1 },
  { "BIT *,C", 0x49cb, 9, 0, 1 },
  { "BIT *,D", 0x4acb, 9, 0, 1 },
  { "BIT *,E", 0x4bcb, 9, 0, 1 },
  { "BIT *,H", 0x4ccb, 9, 0, 1 },
  { "BIT *,(HL)", 0x4ecb, 9, 0, 1 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x4e, 1 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x4e, 1 },
  { "BIT *,L", 0x4dcb, 9, 0, 1 },
  { "BIT *,A", 0x57cb, 9, 0, 2 },
  { "BIT *,B", 0x50cb, 9, 0, 2 },
  { "BIT *,C", 0x51cb, 9, 0, 2 },
  { "BIT *,D", 0x52cb, 9, 0, 2 },
  { "BIT *,E", 0x53cb, 9, 0, 2 },
  { "BIT *,H", 0x54cb, 9, 0, 2 },
  { "BIT *,(HL)", 0x56cb, 9, 0, 2 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x56, 2 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x56, 2 },
  { "BIT *,L", 0x55cb, 9, 0, 2 },
  { "BIT *,A", 0x5fcb, 9, 0, 3 },
  { "BIT *,B", 0x58cb, 9, 0, 3 },
  { "BIT *,C", 0x59cb, 9, 0, 3 },
  { "BIT *,D", 0x5acb, 9, 0, 3 },
  { "BIT *,E", 0x5bcb, 9, 0, 3 },
  { "BIT *,H", 0x5ccb, 9, 0, 3 },
  { "BIT *,(HL)", 0x5ecb, 9, 0, 3 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x5e, 3 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x5e, 3 },
  { "BIT *,L", 0x5dcb, 9, 0, 3 },
  { "BIT *,A", 0x67cb, 9, 0, 4 },
  { "BIT *,B", 0x60cb, 9, 0, 4 },
  { "BIT *,C", 0x61cb, 9, 0, 4 },
  { "BIT *,D", 0x62cb, 9, 0, 4 },
  { "BIT *,E", 0x63cb, 9, 0, 4 },
  { "BIT *,H", 0x64cb, 9, 0, 4 },
  { "BIT *,(HL)", 0x66cb, 9, 0, 4 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x66, 4 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x66, 4 },
  { "BIT *,L", 0x65cb, 9, 0, 4 },
  { "BIT *,A", 0x6fcb, 9, 0, 5 },
  { "BIT *,B", 0x68cb, 9, 0, 5 },
  { "BIT *,C", 0x69cb, 9, 0, 5 },
  { "BIT *,D", 0x6acb, 9, 0, 5 },
  { "BIT *,E", 0x6bcb, 9, 0, 5 },
  { "BIT *,H", 0x6ccb, 9, 0, 5 },
  { "BIT *,(HL)", 0x6ecb, 9, 0, 5 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x6e, 5 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x6e, 5 },
  { "BIT *,L", 0x6dcb, 9, 0, 5 },
  { "BIT *,A", 0x77cb, 9, 0, 6 },
  { "BIT *,B", 0x70cb, 9, 0, 6 },
  { "BIT *,C", 0x71cb, 9, 0, 6 },
  { "BIT *,D", 0x72cb, 9, 0, 6 },
  { "BIT *,E", 0x73cb, 9, 0, 6 },
  { "BIT *,H", 0x74cb, 9, 0, 6 },
  { "BIT *,(HL)", 0x76cb, 9, 0, 6 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x76, 6 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x76, 6 },
  { "BIT *,L", 0x75cb, 9, 0, 6 },
  { "BIT *,A", 0x7fcb, 9, 0, 7 },
  { "BIT *,B", 0x78cb, 9, 0, 7 },
  { "BIT *,C", 0x79cb, 9, 0, 7 },
  { "BIT *,D", 0x7acb, 9, 0, 7 },
  { "BIT *,E", 0x7bcb, 9, 0, 7 },
  { "BIT *,H", 0x7ccb, 9, 0, 7 },
  { "BIT *,(HL)", 0x7ecb, 9, 0, 7 },
  { "BIT *,(IXs)", 0xcbdd, 10, 0x7e, 7 },
  { "BIT *,(IYs)", 0xcbfd, 10, 0x7e, 7 },
  { "BIT *,L", 0x7dcb, 9, 0, 7 },

  { "CALL C,?", 0xdc, 2, 0, 0 },
  { "CALL M,?", 0xfc, 2, 0, 0 },
  { "CALL NC,?", 0xd4, 2, 0, 0 },
  { "CALL NZ,?", 0xc4, 2, 0, 0 },
  { "CALL P,?", 0xf4, 2, 0, 0 },
  { "CALL PE,?", 0xec, 2, 0, 0 },
  { "CALL PO,?", 0xe4, 2, 0, 0 },
  { "CALL Z,?", 0xcc, 2, 0, 0 },
  { "CALL ?", 0xcd, 2, 0, 0 },

  { "CCF", 0x3f, 0, 0, 0 },

  { "CP A", 0xbf, 0, 0, 0 },
  { "CP B", 0xb8, 0, 0, 0 },
  { "CP C", 0xb9, 0, 0, 0 },
  { "CPD", 0xa9ed, 3, 0, 0 },
  { "CP D", 0xba, 0, 0, 0 },
  { "CPDR", 0xb9ed, 3, 0, 0 },
  { "CP E", 0xbb, 0, 0, 0 },
  { "CP H", 0xbc, 0, 0, 0 },
  { "CP (HL)", 0xbe, 0, 0, 0 },
  { "CPI", 0xa1ed, 3, 0, 0 },
  { "CPIR", 0xb1ed, 3, 0, 0 },
  { "CP IXH", 0xbcdd, 3, 0, 0 },
  { "CP IXL", 0xbddd, 3, 0, 0 },
  { "CP (IXs)", 0xbedd, 4, 0, 0 },
  { "CP IYH", 0xbcfd, 3, 0, 0 },
  { "CP IYL", 0xbdfd, 3, 0, 0 },
  { "CP (IYs)", 0xbefd, 4, 0, 0 },
  { "CPL", 0x2f, 0, 0, 0 },
  { "CP L", 0xbd, 0, 0, 0 },
  { "CP x", 0xfe, 1, 0, 0 },

  { "DAA", 0x27, 0, 0, 0 },

  { "DEC A", 0x3d, 0, 0, 0 },
  { "DEC B", 0x5, 0, 0, 0 },
  { "DEC BC", 0xb, 0, 0, 0 },
  { "DEC C", 0xd, 0, 0, 0 },
  { "DEC D", 0x15, 0, 0, 0 },
  { "DEC DE", 0x1b, 0, 0, 0 },
  { "DEC E", 0x1d, 0, 0, 0 },
  { "DEC H", 0x25, 0, 0, 0 },
  { "DEC HL", 0x2b, 0, 0, 0 },
  { "DEC (HL)", 0x35, 0, 0, 0 },
  { "DEC IX", 0x2bdd, 3, 0, 0 },
  { "DEC IXH", 0x25dd, 3, 0, 0 },
  { "DEC IXL", 0x2ddd, 3, 0, 0 },
  { "DEC (IXs)", 0x35dd, 4, 0, 0 },
  { "DEC IY", 0x2bfd, 3, 0, 0 },
  { "DEC IYH", 0x25fd, 3, 0, 0 },
  { "DEC IYL", 0x2dfd, 3, 0, 0 },
  { "DEC (IYs)", 0x35fd, 4, 0, 0 },
  { "DEC L", 0x2d, 0, 0, 0 },
  { "DEC SP", 0x3b, 0, 0, 0 },

  { "DI", 0xf3, 0, 0, 0 },

  { "DJNZ x", 0x10, 11, 0, 0 },

  { "EI", 0xfb, 0, 0, 0 },

  { "EX AF,AF'", 0x8, 0, 0, 0 },
  { "EX DE,HL", 0xeb, 0, 0, 0 },
  { "EX (SP),HL", 0xe3, 0, 0, 0 },
  { "EX (SP),IX", 0xe3dd, 3, 0, 0 },
  { "EX (SP),IY", 0xe3fd, 3, 0, 0 },
  { "EXX", 0xd9, 0, 0, 0 },

  { "HALT", 0x76, 0, 0, 0 },

  { "IM *", 0x46ed, 9, 0, 0 },
  { "IM *", 0x56ed, 9, 0, 1 },
  { "IM *", 0x5eed, 9, 0, 2 },

  { "IN A,(C)", 0x78ed, 3, 0, 0 },
  { "IN A,(x)", 0xdb, 1, 0, 0 },
  { "IN A,x", 0xdb, 1, 0, 0 },
  { "IN B,(C)", 0x40ed, 3, 0, 0 },
  { "IN (C)", 0x70ed, 3, 0, 0 },
  { "IN C,(C)", 0x48ed, 3, 0, 0 },

  { "INC A", 0x3c, 0, 0, 0 },
  { "INC B", 0x4, 0, 0, 0 },
  { "INC BC", 0x3, 0, 0, 0 },
  { "INC C", 0xc, 0, 0, 0 },
  { "INC D", 0x14, 0, 0, 0 },
  { "INC DE", 0x13, 0, 0, 0 },
  { "INC E", 0x1c, 0, 0, 0 },
  { "INC H", 0x24, 0, 0, 0 },
  { "INC HL", 0x23, 0, 0, 0 },
  { "INC (HL)", 0x34, 0, 0, 0 },
  { "INC IX", 0x23dd, 3, 0, 0 },
  { "INC IXH", 0x24dd, 3, 0, 0 },
  { "INC IXL", 0x2cdd, 3, 0, 0 },
  { "INC (IXs)", 0x34dd, 4, 0, 0 },
  { "INC IY", 0x23fd, 3, 0, 0 },
  { "INC IYH", 0x24fd, 3, 0, 0 },
  { "INC IYL", 0x2cfd, 3, 0, 0 },
  { "INC (IYs)", 0x34fd, 4, 0, 0 },
  { "INC L", 0x2c, 0, 0, 0 },
  { "INC SP", 0x33, 0, 0, 0 },

  { "IND", 0xaaed, 3, 0, 0 },
  { "IN D,(C)", 0x50ed, 3, 0, 0 },
  { "INDR", 0xbaed, 3, 0, 0 },
  { "IN E,(C)", 0x58ed, 3, 0, 0 },
  { "IN F,(C)", 0x70ed, 3, 0, 0 },
  { "IN H,(C)", 0x60ed, 3, 0, 0 },
  { "INI", 0xa2ed, 3, 0, 0 },
  { "INIR", 0xb2ed, 3, 0, 0 },
  { "IN L,(C)", 0x68ed, 3, 0, 0 },

  { "JP (HL)", 0xe9, 0, 0, 0 },
  { "JP (IX)", 0xe9dd, 3, 0, 0 },
  { "JP (IY)", 0xe9fd, 3, 0, 0 },
  { "JP C,?", 0xda, 2, 0, 0 },
  { "JP M,?", 0xfa, 2, 0, 0 },
  { "JP NC,?", 0xd2, 2, 0, 0 },
  { "JP NZ,?", 0xc2, 2, 0, 0 },
  { "JP P,?", 0xf2, 2, 0, 0 },
  { "JP PE,?", 0xea, 2, 0, 0 },
  { "JP PO,?", 0xe2, 2, 0, 0 },
  { "JP Z,?", 0xca, 2, 0, 0 },
  { "JP ?", 0xc3, 2, 0, 0 },

  { "JR C,x", 0x38, 11, 0, 0 },
  { "JR NC,x", 0x30, 11, 0, 0 },
  { "JR NZ,x", 0x20, 11, 0, 0 },
  { "JR x", 0x18, 11, 0, 0 },
  { "JR Z,x", 0x28, 11, 0, 0 },

  { "LD A,A", 0x7f, 0, 0, 0 },
  { "LD A,B", 0x78, 0, 0, 0 },
  { "LD A,(BC)", 0xa, 0, 0, 0 },
  { "LD A,C", 0x79, 0, 0, 0 },
  { "LD A,D", 0x7a, 0, 0, 0 },
  { "LD A,(DE)", 0x1a, 0, 0, 0 },
  { "LD A,E", 0x7b, 0, 0, 0 },
  { "LD A,H", 0x7c, 0, 0, 0 },
  { "LD A,(HL)", 0x7e, 0, 0, 0 },
  { "LD A,I", 0x57ed, 3, 0, 0 },
  { "LD A,IXH", 0x7cdd, 3, 0, 0 },
  { "LD A,IXL", 0x7ddd, 3, 0, 0 },
  { "LD A,(IXs)", 0x7edd, 4, 0, 0 },
  { "LD A,IYH", 0x7cfd, 3, 0, 0 },
  { "LD A,IYL", 0x7dfd, 3, 0, 0 },
  { "LD A,(IYs)", 0x7efd, 4, 0, 0 },
  { "LD A,L", 0x7d, 0, 0, 0 },
  { "LD A,R", 0x5fed, 3, 0, 0 },
  { "LD A,(?)", 0x3a, 2, 0, 0 },
  { "LD A,x", 0x3e, 1, 0, 0 },
  { "LD B,A", 0x47, 0, 0, 0 },
  { "LD B,B", 0x40, 0, 0, 0 },
  { "LD B,C", 0x41, 0, 0, 0 },
  { "LD BC,(?)", 0x4bed, 6, 0, 0 },
  { "LD BC,?", 0x1, 2, 0, 0 },
  { "LD (BC),A", 0x2, 0, 0, 0 },
  { "LD B,D", 0x42, 0, 0, 0 },
  { "LD B,E", 0x43, 0, 0, 0 },
  { "LD B,H", 0x44, 0, 0, 0 },
  { "LD B,(HL)", 0x46, 0, 0, 0 },
  { "LD B,IXH", 0x44dd, 3, 0, 0 },
  { "LD B,IXL", 0x45dd, 3, 0, 0 },
  { "LD B,(IXs)", 0x46dd, 4, 0, 0 },
  { "LD B,IYH", 0x44fd, 3, 0, 0 },
  { "LD B,IYL", 0x45fd, 3, 0, 0 },
  { "LD B,(IYs)", 0x46fd, 4, 0, 0 },
  { "LD B,L", 0x45, 0, 0, 0 },
  { "LD B,x", 0x6, 1, 0, 0 },
  { "LD C,A", 0x4f, 0, 0, 0 },
  { "LD C,B", 0x48, 0, 0, 0 },
  { "LD C,C", 0x49, 0, 0, 0 },
  { "LD C,D", 0x4a, 0, 0, 0 },
  { "LD C,E", 0x4b, 0, 0, 0 },
  { "LD C,H", 0x4c, 0, 0, 0 },
  { "LD C,(HL)", 0x4e, 0, 0, 0 },
  { "LD C,IXH", 0x4cdd, 3, 0, 0 },
  { "LD C,IXL", 0x4ddd, 3, 0, 0 },
  { "LD C,(IXs)", 0x4edd, 4, 0, 0 },
  { "LD C,IYH", 0x4cfd, 3, 0, 0 },
  { "LD C,IYL", 0x4dfd, 3, 0, 0 },
  { "LD C,(IYs)", 0x4efd, 4, 0, 0 },
  { "LD C,L", 0x4d, 0, 0, 0 },
  { "LD C,x", 0xe, 1, 0, 0 },
  { "LDD", 0xa8ed, 3, 0, 0 },
  { "LD D,A", 0x57, 0, 0, 0 },
  { "LD D,B", 0x50, 0, 0, 0 },
  { "LD D,C", 0x51, 0, 0, 0 },
  { "LD D,D", 0x52, 0, 0, 0 },
  { "LD D,E", 0x53, 0, 0, 0 },
  { "LD DE,(?)", 0x5bed, 6, 0, 0 },
  { "LD DE,?", 0x11, 2, 0, 0 },
  { "LD (DE),A", 0x12, 0, 0, 0 },
  { "LD D,H", 0x54, 0, 0, 0 },
  { "LD D,(HL)", 0x56, 0, 0, 0 },
  { "LD D,IXH", 0x54dd, 3, 0, 0 },
  { "LD D,IXL", 0x55dd, 3, 0, 0 },
  { "LD D,(IXs)", 0x56dd, 4, 0, 0 },
  { "LD D,IYH", 0x54fd, 3, 0, 0 },
  { "LD D,IYL", 0x55fd, 3, 0, 0 },
  { "LD D,(IYs)", 0x56fd, 4, 0, 0 },
  { "LD D,L", 0x55, 0, 0, 0 },
  { "LDDR", 0xb8ed, 3, 0, 0 },
  { "LD D,x", 0x16, 1, 0, 0 },
  { "LD E,A", 0x5f, 0, 0, 0 },
  { "LD E,B", 0x58, 0, 0, 0 },
  { "LD E,C", 0x59, 0, 0, 0 },
  { "LD E,D", 0x5a, 0, 0, 0 },
  { "LD E,E", 0x5b, 0, 0, 0 },
  { "LD E,H", 0x5c, 0, 0, 0 },
  { "LD E,(HL)", 0x5e, 0, 0, 0 },
  { "LD E,IXH", 0x5cdd, 3, 0, 0 },
  { "LD E,IXL", 0x5ddd, 3, 0, 0 },
  { "LD E,(IXs)", 0x5edd, 4, 0, 0 },
  { "LD E,IYH", 0x5cfd, 3, 0, 0 },
  { "LD E,IYL", 0x5dfd, 3, 0, 0 },
  { "LD E,(IYs)", 0x5efd, 4, 0, 0 },
  { "LD E,L", 0x5d, 0, 0, 0 },
  { "LD E,x", 0x1e, 1, 0, 0 },
  { "LD H,A", 0x67, 0, 0, 0 },
  { "LD H,B", 0x60, 0, 0, 0 },
  { "LD H,C", 0x61, 0, 0, 0 },
  { "LD H,D", 0x62, 0, 0, 0 },
  { "LD H,E", 0x63, 0, 0, 0 },
  { "LD H,H", 0x64, 0, 0, 0 },
  { "LD H,(HL)", 0x66, 0, 0, 0 },
  { "LD H,(IXs)", 0x66dd, 4, 0, 0 },
  { "LD H,(IYs)", 0x66fd, 4, 0, 0 },
  { "LD H,L", 0x65, 0, 0, 0 },
  { "LD H,x", 0x26, 1, 0, 0 },
  { "LD HL,(?)", 0x2a, 2, 0, 0 },
  { "LD HL,?", 0x21, 2, 0, 0 },
  { "LD (HL),A", 0x77, 0, 0, 0 },
  { "LD (HL),B", 0x70, 0, 0, 0 },
  { "LD (HL),C", 0x71, 0, 0, 0 },
  { "LD (HL),D", 0x72, 0, 0, 0 },
  { "LD (HL),E", 0x73, 0, 0, 0 },
  { "LD (HL),H", 0x74, 0, 0, 0 },
  { "LD (HL),L", 0x75, 0, 0, 0 },
  { "LD (HL),x", 0x36, 1, 0, 0 },
  { "LD L,A", 0x6f, 0, 0, 0 },
  { "LD L,B", 0x68, 0, 0, 0 },
  { "LD L,C", 0x69, 0, 0, 0 },
  { "LD L,D", 0x6a, 0, 0, 0 },
  { "LD L,E", 0x6b, 0, 0, 0 },
  { "LD L,H", 0x6c, 0, 0, 0 },
  { "LD L,(HL)", 0x6e, 0, 0, 0 },
  { "LD L,(IXs)", 0x6edd, 4, 0, 0 },
  { "LD L,(IYs)", 0x6efd, 4, 0, 0 },
  { "LD L,L", 0x6d, 0, 0, 0 },
  { "LD L,x", 0x2e, 1, 0, 0 },
  { "LD R,A", 0x4fed, 3, 0, 0 },
  { "LD SP,HL", 0xf9, 0, 0, 0 },
  { "LD SP,IX", 0xf9dd, 3, 0, 0 },
  { "LD SP,IY", 0xf9fd, 3, 0, 0 },
  { "LD SP,(?)", 0x7bed, 6, 0, 0 },
  { "LD SP,?", 0x31, 2, 0, 0 },
  { "LDI", 0xa0ed, 3, 0, 0 },
  { "LD I,A", 0x47ed, 3, 0, 0 },
  { "LDIR", 0xb0ed, 3, 0, 0 },
  { "LD IX,(?)", 0x2add, 6, 0, 0 },
  { "LD IX,?", 0x21dd, 6, 0, 0 },
  { "LD IXH,A", 0x67dd, 3, 0, 0 },
  { "LD IXH,B", 0x60dd, 3, 0, 0 },
  { "LD IXH,C", 0x61dd, 3, 0, 0 },
  { "LD IXH,D", 0x62dd, 3, 0, 0 },
  { "LD IXH,E", 0x63dd, 3, 0, 0 },
  { "LD IXH,IXH", 0x64dd, 3, 0, 0 },
  { "LD IXH,IXL", 0x65dd, 3, 0, 0 },
  { "LD IXH,x", 0x26dd, 4, 0, 0 },
  { "LD IXL,A", 0x6fdd, 3, 0, 0 },
  { "LD IXL,B", 0x68dd, 3, 0, 0 },
  { "LD IXL,C", 0x69dd, 3, 0, 0 },
  { "LD IXL,D", 0x6add, 3, 0, 0 },
  { "LD IXL,E", 0x6bdd, 3, 0, 0 },
  { "LD IXL,IXH", 0x6cdd, 3, 0, 0 },
  { "LD IXL,IXL", 0x6ddd, 3, 0, 0 },
  { "LD IXL,x", 0x2edd, 4, 0, 0 },
  { "LD (IXs),A", 0x77dd, 4, 0, 0 },
  { "LD (IXs),B", 0x70dd, 4, 0, 0 },
  { "LD (IXs),C", 0x71dd, 4, 0, 0 },
  { "LD (IXs),D", 0x72dd, 4, 0, 0 },
  { "LD (IXs),E", 0x73dd, 4, 0, 0 },
  { "LD (IXs),H", 0x74dd, 4, 0, 0 },
  { "LD (IXs),L", 0x75dd, 4, 0, 0 },
  { "LD (IXs),x", 0x36dd, 7, 0, 0 },
  { "LD IY,(?)", 0x2afd, 6, 0, 0 },
  { "LD IY,?", 0x21fd, 6, 0, 0 },
  { "LD IYH,A", 0x67fd, 3, 0, 0 },
  { "LD IYH,B", 0x60fd, 3, 0, 0 },
  { "LD IYH,C", 0x61fd, 3, 0, 0 },
  { "LD IYH,D", 0x62fd, 3, 0, 0 },
  { "LD IYH,E", 0x63fd, 3, 0, 0 },
  { "LD IYH,IYH", 0x64fd, 3, 0, 0 },
  { "LD IYH,IYL", 0x65fd, 3, 0, 0 },
  { "LD IYH,x", 0x26fd, 4, 0, 0 },
  { "LD IYL,A", 0x6ffd, 3, 0, 0 },
  { "LD IYL,B", 0x68fd, 3, 0, 0 },
  { "LD IYL,C", 0x69fd, 3, 0, 0 },
  { "LD IYL,D", 0x6afd, 3, 0, 0 },
  { "LD IYL,E", 0x6bfd, 3, 0, 0 },
  { "LD IYL,IYH", 0x6cfd, 3, 0, 0 },
  { "LD IYL,IYL", 0x6dfd, 3, 0, 0 },
  { "LD IYL,x", 0x2efd, 4, 0, 0 },
  { "LD (IYs),A", 0x77fd, 4, 0, 0 },
  { "LD (IYs),B", 0x70fd, 4, 0, 0 },
  { "LD (IYs),C", 0x71fd, 4, 0, 0 },
  { "LD (IYs),D", 0x72fd, 4, 0, 0 },
  { "LD (IYs),E", 0x73fd, 4, 0, 0 },
  { "LD (IYs),H", 0x74fd, 4, 0, 0 },
  { "LD (IYs),L", 0x75fd, 4, 0, 0 },
  { "LD (IYs),x", 0x36fd, 7, 0, 0 },
  { "LD (?),A", 0x32, 2, 0, 0 },
  { "LD (?),BC", 0x43ed, 6, 0, 0 },
  { "LD (?),DE", 0x53ed, 6, 0, 0 },
  { "LD (?),HL", 0x22, 2, 0, 0 },
  { "LD (?),SP", 0x73ed, 6, 0, 0 },
  { "LD (?),IY", 0x22fd, 6, 0, 0 },
  { "LD (?),IX", 0x22dd, 6, 0, 0 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0x87, 0 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0x87, 0 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0x8f, 1 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0x8f, 1 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0x97, 2 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0x97, 2 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0x9f, 3 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0x9f, 3 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0xa7, 4 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0xa7, 4 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0xaf, 5 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0xaf, 5 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0xb7, 6 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0xb7, 6 },
  { "LD A,RES *,(IXs)", 0xcbdd, 10, 0xbf, 7 },
  { "LD A,RES *,(IYs)", 0xcbfd, 10, 0xbf, 7 },
  { "LD A,RLC (IXs)", 0xcbdd, 5, 0x07, 0 },
  { "LD A,RLC (IYs)", 0xcbfd, 5, 0x07, 0 },
  { "LD A,RL (IXs)", 0xcbdd, 5, 0x17, 0 },
  { "LD A,RL (IYs)", 0xcbfd, 5, 0x17, 0 },
  { "LD A,RRC (IXs)", 0xcbdd, 5, 0x0f, 0 },
  { "LD A,RRC (IYs)", 0xcbfd, 5, 0x0f, 0 },
  { "LD A,RR (IXs)", 0xcbdd, 5, 0x1f, 0 },
  { "LD A,RR (IYs)", 0xcbfd, 5, 0x1f, 0 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xc7, 0 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xc7, 0 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xcf, 1 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xcf, 1 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xd7, 2 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xd7, 2 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xdf, 3 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xdf, 3 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xe7, 4 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xe7, 4 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xef, 5 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xef, 5 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xf7, 6 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xf7, 6 },
  { "LD A,SET *,(IXs)", 0xcbdd, 10, 0xff, 7 },
  { "LD A,SET *,(IYs)", 0xcbfd, 10, 0xff, 7 },
  { "LD A,SLA (IXs)", 0xcbdd, 5, 0x27, 0 },
  { "LD A,SLA (IYs)", 0xcbfd, 5, 0x27, 0 },
  { "LD A,SLL (IXs)", 0xcbdd, 5, 0x37, 0 },
  { "LD A,SLL (IYs)", 0xcbfd, 5, 0x37, 0 },
  { "LD A,SRA (IXs)", 0xcbdd, 5, 0x2f, 0 },
  { "LD A,SRA (IYs)", 0xcbfd, 5, 0x2f, 0 },
  { "LD A,SRL (IXs)", 0xcbdd, 5, 0x3f, 0 },
  { "LD A,SRL (IYs)", 0xcbfd, 5, 0x3f, 0 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0x80, 0 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0x80, 0 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0x88, 1 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0x88, 1 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0x90, 2 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0x90, 2 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0x98, 3 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0x98, 3 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0xa0, 4 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0xa0, 4 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0xa8, 5 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0xa8, 5 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0xb0, 6 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0xb0, 6 },
  { "LD B,RES *,(IXs)", 0xcbdd, 10, 0xb8, 7 },
  { "LD B,RES *,(IYs)", 0xcbfd, 10, 0xb8, 7 },
  { "LD B,RLC (IXs)", 0xcbdd, 5, 0x00, 0 },
  { "LD B,RLC (IYs)", 0xcbfd, 5, 0x00, 0 },
  { "LD B,RL (IXs)", 0xcbdd, 5, 0x10, 0 },
  { "LD B,RL (IYs)", 0xcbfd, 5, 0x10, 0 },
  { "LD B,RRC (IXs)", 0xcbdd, 5, 0x08, 0 },
  { "LD B,RRC (IYs)", 0xcbfd, 5, 0x08, 0 },
  { "LD B,RR (IXs)", 0xcbdd, 5, 0x18, 0 },
  { "LD B,RR (IYs)", 0xcbfd, 5, 0x18, 0 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xc0, 0 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xc0, 0 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xc8, 1 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xc8, 1 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xd0, 2 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xd0, 2 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xd8, 3 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xd8, 3 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xe0, 4 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xe0, 4 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xe8, 5 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xe8, 5 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xf0, 6 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xf0, 6 },
  { "LD B,SET *,(IXs)", 0xcbdd, 10, 0xf8, 7 },
  { "LD B,SET *,(IYs)", 0xcbfd, 10, 0xf8, 7 },
  { "LD B,SLA (IXs)", 0xcbdd, 5, 0x20, 0 },
  { "LD B,SLA (IYs)", 0xcbfd, 5, 0x20, 0 },
  { "LD B,SLL (IXs)", 0xcbdd, 5, 0x30, 0 },
  { "LD B,SLL (IYs)", 0xcbfd, 5, 0x30, 0 },
  { "LD B,SRA (IXs)", 0xcbdd, 5, 0x28, 0 },
  { "LD B,SRA (IYs)", 0xcbfd, 5, 0x28, 0 },
  { "LD B,SRL (IXs)", 0xcbdd, 5, 0x38, 0 },
  { "LD B,SRL (IYs)", 0xcbfd, 5, 0x38, 0 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0x81, 0 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0x81, 0 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0x89, 1 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0x89, 1 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0x91, 2 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0x91, 2 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0x99, 3 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0x99, 3 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0xa1, 4 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0xa1, 4 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0xa9, 5 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0xa9, 5 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0xb1, 6 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0xb1, 6 },
  { "LD C,RES *,(IXs)", 0xcbdd, 10, 0xb9, 7 },
  { "LD C,RES *,(IYs)", 0xcbfd, 10, 0xb9, 7 },
  { "LD C,RLC (IXs)", 0xcbdd, 5, 0x01, 0 },
  { "LD C,RLC (IYs)", 0xcbfd, 5, 0x01, 0 },
  { "LD C,RL (IXs)", 0xcbdd, 5, 0x11, 0 },
  { "LD C,RL (IYs)", 0xcbfd, 5, 0x11, 0 },
  { "LD C,RRC (IXs)", 0xcbdd, 5, 0x09, 0 },
  { "LD C,RRC (IYs)", 0xcbfd, 5, 0x09, 0 },
  { "LD C,RR (IXs)", 0xcbdd, 5, 0x19, 0 },
  { "LD C,RR (IYs)", 0xcbfd, 5, 0x19, 0 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xc1, 0 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xc1, 0 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xc9, 1 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xc9, 1 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xd1, 2 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xd1, 2 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xd9, 3 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xd9, 3 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xe1, 4 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xe1, 4 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xe9, 5 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xe9, 5 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xf1, 6 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xf1, 6 },
  { "LD C,SET *,(IXs)", 0xcbdd, 10, 0xf9, 7 },
  { "LD C,SET *,(IYs)", 0xcbfd, 10, 0xf9, 7 },
  { "LD C,SLA (IXs)", 0xcbdd, 5, 0x21, 0 },
  { "LD C,SLA (IYs)", 0xcbfd, 5, 0x21, 0 },
  { "LD C,SLL (IXs)", 0xcbdd, 5, 0x31, 0 },
  { "LD C,SLL (IYs)", 0xcbfd, 5, 0x31, 0 },
  { "LD C,SRA (IXs)", 0xcbdd, 5, 0x29, 0 },
  { "LD C,SRA (IYs)", 0xcbfd, 5, 0x29, 0 },
  { "LD C,SRL (IXs)", 0xcbdd, 5, 0x39, 0 },
  { "LD C,SRL (IYs)", 0xcbfd, 5, 0x39, 0 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0x82, 0 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0x82, 0 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0x8a, 1 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0x8a, 1 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0x92, 2 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0x92, 2 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0x9a, 3 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0x9a, 3 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0xa2, 4 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0xa2, 4 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0xaa, 5 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0xaa, 5 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0xb2, 6 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0xb2, 6 },
  { "LD D,RES *,(IXs)", 0xcbdd, 10, 0xba, 7 },
  { "LD D,RES *,(IYs)", 0xcbfd, 10, 0xba, 7 },
  { "LD D,RLC (IXs)", 0xcbdd, 5, 0x02, 0 },
  { "LD D,RLC (IYs)", 0xcbfd, 5, 0x02, 0 },
  { "LD D,RL (IXs)", 0xcbdd, 5, 0x12, 0 },
  { "LD D,RL (IYs)", 0xcbfd, 5, 0x12, 0 },
  { "LD D,RRC (IXs)", 0xcbdd, 5, 0x0a, 0 },
  { "LD D,RRC (IYs)", 0xcbfd, 5, 0x0a, 0 },
  { "LD D,RR (IXs)", 0xcbdd, 5, 0x1a, 0 },
  { "LD D,RR (IYs)", 0xcbfd, 5, 0x1a, 0 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xc2, 0 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xc2, 0 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xca, 1 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xca, 1 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xd2, 2 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xd2, 2 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xda, 3 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xda, 3 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xe2, 4 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xe2, 4 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xea, 5 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xea, 5 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xf2, 6 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xf2, 6 },
  { "LD D,SET *,(IXs)", 0xcbdd, 10, 0xfa, 7 },
  { "LD D,SET *,(IYs)", 0xcbfd, 10, 0xfa, 7 },
  { "LD D,SLA (IXs)", 0xcbdd, 5, 0x22, 0 },
  { "LD D,SLA (IYs)", 0xcbfd, 5, 0x22, 0 },
  { "LD D,SLL (IXs)", 0xcbdd, 5, 0x32, 0 },
  { "LD D,SLL (IYs)", 0xcbfd, 5, 0x32, 0 },
  { "LD D,SRA (IXs)", 0xcbdd, 5, 0x2a, 0 },
  { "LD D,SRA (IYs)", 0xcbfd, 5, 0x2a, 0 },
  { "LD D,SRL (IXs)", 0xcbdd, 5, 0x3a, 0 },
  { "LD D,SRL (IYs)", 0xcbfd, 5, 0x3a, 0 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0x83, 0 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0x83, 0 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0x8b, 1 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0x8b, 1 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0x93, 2 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0x93, 2 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0x9b, 3 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0x9b, 3 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0xa3, 4 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0xa3, 4 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0xab, 5 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0xab, 5 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0xb3, 6 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0xb3, 6 },
  { "LD E,RES *,(IXs)", 0xcbdd, 10, 0xbb, 7 },
  { "LD E,RES *,(IYs)", 0xcbfd, 10, 0xbb, 7 },
  { "LD E,RLC (IXs)", 0xcbdd, 5, 0x03, 0 },
  { "LD E,RLC (IYs)", 0xcbfd, 5, 0x03, 0 },
  { "LD E,RL (IXs)", 0xcbdd, 5, 0x13, 0 },
  { "LD E,RL (IYs)", 0xcbfd, 5, 0x13, 0 },
  { "LD E,RRC (IXs)", 0xcbdd, 5, 0x0b, 0 },
  { "LD E,RRC (IYs)", 0xcbfd, 5, 0x0b, 0 },
  { "LD E,RR (IXs)", 0xcbdd, 5, 0x1b, 0 },
  { "LD E,RR (IYs)", 0xcbfd, 5, 0x1b, 0 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xc3, 0 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xc3, 0 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xcb, 1 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xcb, 1 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xd3, 2 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xd3, 2 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xdb, 3 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xdb, 3 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xe3, 4 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xe3, 4 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xeb, 5 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xeb, 5 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xf3, 6 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xf3, 6 },
  { "LD E,SET *,(IXs)", 0xcbdd, 10, 0xfb, 7 },
  { "LD E,SET *,(IYs)", 0xcbfd, 10, 0xfb, 7 },
  { "LD E,SLA (IXs)", 0xcbdd, 5, 0x23, 0 },
  { "LD E,SLA (IYs)", 0xcbfd, 5, 0x23, 0 },
  { "LD E,SLL (IXs)", 0xcbdd, 5, 0x33, 0 },
  { "LD E,SLL (IYs)", 0xcbfd, 5, 0x33, 0 },
  { "LD E,SRA (IXs)", 0xcbdd, 5, 0x2b, 0 },
  { "LD E,SRA (IYs)", 0xcbfd, 5, 0x2b, 0 },
  { "LD E,SRL (IXs)", 0xcbdd, 5, 0x3b, 0 },
  { "LD E,SRL (IYs)", 0xcbfd, 5, 0x3b, 0 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0x84, 0 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0x84, 0 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0x8c, 1 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0x8c, 1 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0x94, 2 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0x94, 2 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0x9c, 3 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0x9c, 3 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0xa4, 4 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0xa4, 4 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0xac, 5 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0xac, 5 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0xb4, 6 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0xb4, 6 },
  { "LD H,RES *,(IXs)", 0xcbdd, 10, 0xbc, 7 },
  { "LD H,RES *,(IYs)", 0xcbfd, 10, 0xbc, 7 },
  { "LD H,RLC (IXs)", 0xcbdd, 5, 0x04, 0 },
  { "LD H,RLC (IYs)", 0xcbfd, 5, 0x04, 0 },
  { "LD H,RL (IXs)", 0xcbdd, 5, 0x14, 0 },
  { "LD H,RL (IYs)", 0xcbfd, 5, 0x14, 0 },
  { "LD H,RRC (IXs)", 0xcbdd, 5, 0x0c, 0 },
  { "LD H,RRC (IYs)", 0xcbfd, 5, 0x0c, 0 },
  { "LD H,RR (IXs)", 0xcbdd, 5, 0x1c, 0 },
  { "LD H,RR (IYs)", 0xcbfd, 5, 0x1c, 0 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xc4, 0 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xc4, 0 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xcc, 1 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xcc, 1 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xd4, 2 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xd4, 2 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xdc, 3 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xdc, 3 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xe4, 4 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xe4, 4 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xec, 5 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xec, 5 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xf4, 6 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xf4, 6 },
  { "LD H,SET *,(IXs)", 0xcbdd, 10, 0xfc, 7 },
  { "LD H,SET *,(IYs)", 0xcbfd, 10, 0xfc, 7 },
  { "LD H,SLA (IXs)", 0xcbdd, 5, 0x24, 0 },
  { "LD H,SLA (IYs)", 0xcbfd, 5, 0x24, 0 },
  { "LD H,SLL (IXs)", 0xcbdd, 5, 0x34, 0 },
  { "LD H,SLL (IYs)", 0xcbfd, 5, 0x34, 0 },
  { "LD H,SRA (IXs)", 0xcbdd, 5, 0x2c, 0 },
  { "LD H,SRA (IYs)", 0xcbfd, 5, 0x2c, 0 },
  { "LD H,SRL (IXs)", 0xcbdd, 5, 0x3c, 0 },
  { "LD H,SRL (IYs)", 0xcbfd, 5, 0x3c, 0 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0x85, 0 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0x85, 0 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0x8d, 1 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0x8d, 1 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0x95, 2 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0x95, 2 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0x9d, 3 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0x9d, 3 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0xa5, 4 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0xa5, 4 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0xad, 5 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0xad, 5 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0xb5, 6 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0xb5, 6 },
  { "LD L,RES *,(IXs)", 0xcbdd, 10, 0xbd, 7 },
  { "LD L,RES *,(IYs)", 0xcbfd, 10, 0xbd, 7 },
  { "LD L,RLC (IXs)", 0xcbdd, 5, 0x05, 0 },
  { "LD L,RLC (IYs)", 0xcbfd, 5, 0x05, 0 },
  { "LD L,RL (IXs)", 0xcbdd, 5, 0x15, 0 },
  { "LD L,RL (IYs)", 0xcbfd, 5, 0x15, 0 },
  { "LD L,RRC (IXs)", 0xcbdd, 5, 0x0d, 0 },
  { "LD L,RRC (IYs)", 0xcbfd, 5, 0x0d, 0 },
  { "LD L,RR (IXs)", 0xcbdd, 5, 0x1d, 0 },
  { "LD L,RR (IYs)", 0xcbfd, 5, 0x1d, 0 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xc5, 0 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xc5, 0 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xcd, 1 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xcd, 1 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xd5, 2 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xd5, 2 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xdd, 3 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xdd, 3 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xe5, 4 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xe5, 4 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xed, 5 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xed, 5 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xf5, 6 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xf5, 6 },
  { "LD L,SET *,(IXs)", 0xcbdd, 10, 0xfd, 7 },
  { "LD L,SET *,(IYs)", 0xcbfd, 10, 0xfd, 7 },
  { "LD L,SLA (IXs)", 0xcbdd, 5, 0x25, 0 },
  { "LD L,SLA (IYs)", 0xcbfd, 5, 0x25, 0 },
  { "LD L,SLL (IXs)", 0xcbdd, 5, 0x35, 0 },
  { "LD L,SLL (IYs)", 0xcbfd, 5, 0x35, 0 },
  { "LD L,SRA (IXs)", 0xcbdd, 5, 0x2d, 0 },
  { "LD L,SRA (IYs)", 0xcbfd, 5, 0x2d, 0 },
  { "LD L,SRL (IXs)", 0xcbdd, 5, 0x3d, 0 },
  { "LD L,SRL (IYs)", 0xcbfd, 5, 0x3d, 0 },

  { "NEG", 0x44ed, 3, 0, 0 },

  { "NOP", 0x00, 0, 0, 0 },

  { "OR A", 0xb7, 0, 0, 0 },
  { "OR B", 0xb0, 0, 0, 0 },
  { "OR C", 0xb1, 0, 0, 0 },
  { "OR D", 0xb2, 0, 0, 0 },
  { "OR E", 0xb3, 0, 0, 0 },
  { "OR H", 0xb4, 0, 0, 0 },
  { "OR (HL)", 0xb6, 0, 0, 0 },
  { "OR IXH", 0xb4dd, 3, 0, 0 },
  { "OR IXL", 0xb5dd, 3, 0, 0 },
  { "OR (IXs)", 0xb6dd, 4, 0, 0 },
  { "OR IYH", 0xb4fd, 3, 0, 0 },
  { "OR IYL", 0xb5fd, 3, 0, 0 },
  { "OR (IYs)", 0xb6fd, 4, 0, 0 },
  { "OR L", 0xb5, 0, 0, 0 },
  { "OR x", 0xf6, 1, 0, 0 },

  { "OTDR", 0xbbed, 3, 0, 0 },
  { "OTIR", 0xb3ed, 3, 0, 0 },

  { "OUT (C),0", 0x71ed, 3, 0, 0 },
  { "OUT (C),A", 0x79ed, 3, 0, 0 },
  { "OUT (C),B", 0x41ed, 3, 0, 0 },
  { "OUT (C),C", 0x49ed, 3, 0, 0 },
  { "OUT (C),D", 0x51ed, 3, 0, 0 },
  { "OUT (C),E", 0x59ed, 3, 0, 0 },
  { "OUT (C),H", 0x61ed, 3, 0, 0 },
  { "OUT (C),L", 0x69ed, 3, 0, 0 },
  { "OUT (x),A", 0xd3, 1, 0, 0 },
  { "OUTD", 0xabed, 3, 0, 0 },
  { "OUTI", 0xa3ed, 3, 0, 0 },

  { "POP AF", 0xf1, 0, 0, 0 },
  { "POP BC", 0xc1, 0, 0, 0 },
  { "POP DE", 0xd1, 0, 0, 0 },
  { "POP HL", 0xe1, 0, 0, 0 },
  { "POP IX", 0xe1dd, 3, 0, 0 },
  { "POP IY", 0xe1fd, 3, 0, 0 },

  { "PUSH AF", 0xf5, 0, 0, 0 },
  { "PUSH BC", 0xc5, 0, 0, 0 },
  { "PUSH DE", 0xd5, 0, 0, 0 },
  { "PUSH HL", 0xe5, 0, 0, 0 },
  { "PUSH IX", 0xe5dd, 3, 0, 0 },
  { "PUSH IY", 0xe5fd, 3, 0, 0 },

  { "RES *,A", 0x87cb, 9, 0, 0 },
  { "RES *,B", 0x80cb, 9, 0, 0 },
  { "RES *,C", 0x81cb, 9, 0, 0 },
  { "RES *,D", 0x82cb, 9, 0, 0 },
  { "RES *,E", 0x83cb, 9, 0, 0 },
  { "RES *,H", 0x84cb, 9, 0, 0 },
  { "RES *,(HL)", 0x86cb, 9, 0, 0 },
  { "RES *,(IXs)", 0xcbdd, 10, 0x86, 0 },
  { "RES *,(IYs)", 0xcbfd, 10, 0x86, 0 },
  { "RES *,L", 0x85cb, 9, 0, 0 },
  { "RES *,A", 0x8fcb, 9, 0, 1 },
  { "RES *,B", 0x88cb, 9, 0, 1 },
  { "RES *,C", 0x89cb, 9, 0, 1 },
  { "RES *,D", 0x8acb, 9, 0, 1 },
  { "RES *,E", 0x8bcb, 9, 0, 1 },
  { "RES *,H", 0x8ccb, 9, 0, 1 },
  { "RES *,(HL)", 0x8ecb, 9, 0, 1 },
  { "RES *,(IXs)", 0xcbdd, 10, 0x8e, 1 },
  { "RES *,(IYs)", 0xcbfd, 10, 0x8e, 1 },
  { "RES *,L", 0x8dcb, 9, 0, 1 },
  { "RES *,A", 0x97cb, 9, 0, 2 },
  { "RES *,B", 0x90cb, 9, 0, 2 },
  { "RES *,C", 0x91cb, 9, 0, 2 },
  { "RES *,D", 0x92cb, 9, 0, 2 },
  { "RES *,E", 0x93cb, 9, 0, 2 },
  { "RES *,H", 0x94cb, 9, 0, 2 },
  { "RES *,(HL)", 0x96cb, 9, 0, 2 },
  { "RES *,(IXs)", 0xcbdd, 10, 0x96, 2 },
  { "RES *,(IYs)", 0xcbfd, 10, 0x96, 2 },
  { "RES *,L", 0x95cb, 9, 0, 2 },
  { "RES *,A", 0x9fcb, 9, 0, 3 },
  { "RES *,B", 0x98cb, 9, 0, 3 },
  { "RES *,C", 0x99cb, 9, 0, 3 },
  { "RES *,D", 0x9acb, 9, 0, 3 },
  { "RES *,E", 0x9bcb, 9, 0, 3 },
  { "RES *,H", 0x9ccb, 9, 0, 3 },
  { "RES *,(HL)", 0x9ecb, 9, 0, 3 },
  { "RES *,(IXs)", 0xcbdd, 10, 0x9e, 3 },
  { "RES *,(IYs)", 0xcbfd, 10, 0x9e, 3 },
  { "RES *,L", 0x9dcb, 9, 0, 3 },
  { "RES *,A", 0xa7cb, 9, 0, 4 },
  { "RES *,B", 0xa0cb, 9, 0, 4 },
  { "RES *,C", 0xa1cb, 9, 0, 4 },
  { "RES *,D", 0xa2cb, 9, 0, 4 },
  { "RES *,E", 0xa3cb, 9, 0, 4 },
  { "RES *,H", 0xa4cb, 9, 0, 4 },
  { "RES *,(HL)", 0xa6cb, 9, 0, 4 },
  { "RES *,(IXs)", 0xcbdd, 10, 0xa6, 4 },
  { "RES *,(IYs)", 0xcbfd, 10, 0xa6, 4 },
  { "RES *,L", 0xa5cb, 9, 0, 4 },
  { "RES *,A", 0xafcb, 9, 0, 5 },
  { "RES *,B", 0xa8cb, 9, 0, 5 },
  { "RES *,C", 0xa9cb, 9, 0, 5 },
  { "RES *,D", 0xaacb, 9, 0, 5 },
  { "RES *,E", 0xabcb, 9, 0, 5 },
  { "RES *,H", 0xaccb, 9, 0, 5 },
  { "RES *,(HL)", 0xaecb, 9, 0, 5 },
  { "RES *,(IXs)", 0xcbdd, 10, 0xae, 5 },
  { "RES *,(IYs)", 0xcbfd, 10, 0xae, 5 },
  { "RES *,L", 0xadcb, 9, 0, 5 },
  { "RES *,A", 0xb7cb, 9, 0, 6 },
  { "RES *,B", 0xb0cb, 9, 0, 6 },
  { "RES *,C", 0xb1cb, 9, 0, 6 },
  { "RES *,D", 0xb2cb, 9, 0, 6 },
  { "RES *,E", 0xb3cb, 9, 0, 6 },
  { "RES *,H", 0xb4cb, 9, 0, 6 },
  { "RES *,(HL)", 0xb6cb, 9, 0, 6 },
  { "RES *,(IXs)", 0xcbdd, 10, 0xb6, 6 },
  { "RES *,(IYs)", 0xcbfd, 10, 0xb6, 6 },
  { "RES *,L", 0xb5cb, 9, 0, 6 },
  { "RES *,A", 0xbfcb, 9, 0, 7 },
  { "RES *,B", 0xb8cb, 9, 0, 7 },
  { "RES *,C", 0xb9cb, 9, 0, 7 },
  { "RES *,D", 0xbacb, 9, 0, 7 },
  { "RES *,E", 0xbbcb, 9, 0, 7 },
  { "RES *,H", 0xbccb, 9, 0, 7 },
  { "RES *,(HL)", 0xbecb, 9, 0, 7 },
  { "RES *,(IXs)", 0xcbdd, 10, 0xbe, 7 },
  { "RES *,(IYs)", 0xcbfd, 10, 0xbe, 7 },
  { "RES *,L", 0xbdcb, 9, 0, 7 },

  { "RET C", 0xd8, 0, 0, 0 },
  { "RETI", 0x4ded, 3, 0, 0 },
  { "RETN", 0x45ed, 3, 0, 0 },
  { "RET M", 0xf8, 0, 0, 0 },
  { "RET NC", 0xd0, 0, 0, 0 },
  { "RET NZ", 0xc0, 0, 0, 0 },
  { "RET P", 0xf0, 0, 0, 0 },
  { "RET PE", 0xe8, 0, 0, 0 },
  { "RET PO", 0xe0, 0, 0, 0 },
  { "RET Z", 0xc8, 0, 0, 0 },
  { "RET", 0xc9, 0, 0, 0 },

  { "RLA", 0x17, 0, 0, 0 },
  { "RL A", 0x17cb, 3, 0, 0 },
  { "RL B", 0x10cb, 3, 0, 0 },
  { "RL C", 0x11cb, 3, 0, 0 },
  { "RLCA", 0x7, 0, 0, 0 },
  { "RLC A", 0x7cb, 3, 0, 0 },
  { "RLC B", 0xcb, 3, 0, 0 },
  { "RLC C", 0x1cb, 3, 0, 0 },
  { "RLC D", 0x2cb, 3, 0, 0 },
  { "RLC E", 0x3cb, 3, 0, 0 },
  { "RLC H", 0x4cb, 3, 0, 0 },
  { "RLC (HL)", 0x6cb, 3, 0, 0 },
  { "RLC (IXs)", 0xcbdd, 5, 0x06, 0 },
  { "RLC (IYs)", 0xcbfd, 5, 0x06, 0 },
  { "RLC L", 0x5cb, 3, 0, 0 },
  { "RL D", 0x12cb, 3, 0, 0 },
  { "RLD", 0x6fed, 3, 0, 0 },
  { "RL E", 0x13cb, 3, 0, 0 },
  { "RL H", 0x14cb, 3, 0, 0 },
  { "RL (HL)", 0x16cb, 3, 0, 0 },
  { "RL (IXs)", 0xcbdd, 5, 0x16, 0 },
  { "RL (IYs)", 0xcbfd, 5, 0x16, 0 },
  { "RL L", 0x15cb, 3, 0, 0 },

  { "RRA", 0x1f, 0, 0, 0 },
  { "RR A", 0x1fcb, 3, 0, 0 },
  { "RR B", 0x18cb, 3, 0, 0 },
  { "RR C", 0x19cb, 3, 0, 0 },
  { "RRCA", 0xf, 0, 0, 0 },
  { "RRC A", 0xfcb, 3, 0, 0 },
  { "RRC B", 0x8cb, 3, 0, 0 },
  { "RRC C", 0x9cb, 3, 0, 0 },
  { "RRC D", 0xacb, 3, 0, 0 },
  { "RRC E", 0xbcb, 3, 0, 0 },
  { "RRC H", 0xccb, 3, 0, 0 },
  { "RRC (HL)", 0xecb, 3, 0, 0 },
  { "RRC (IXs)", 0xcbdd, 5, 0x0e, 0 },
  { "RRC (IYs)", 0xcbfd, 5, 0x0e, 0 },
  { "RRC L", 0xdcb, 3, 0, 0 },
  { "RR D", 0x1acb, 3, 0, 0 },
  { "RRD", 0x67ed, 3, 0, 0 },
  { "RR E", 0x1bcb, 3, 0, 0 },
  { "RR H", 0x1ccb, 3, 0, 0 },
  { "RR (HL)", 0x1ecb, 3, 0, 0 },
  { "RR (IXs)", 0xcbdd, 5, 0x1e, 0 },
  { "RR (IYs)", 0xcbfd, 5, 0x1e, 0 },
  { "RR L", 0x1dcb, 3, 0, 0 },

  { "RST *", 0xc7, 8, 0, 0x00 },
  { "RST *", 0xcf, 8, 0, 0x08 },
  { "RST *", 0xd7, 8, 0, 0x10 },
  { "RST *", 0xdf, 8, 0, 0x18 },
  { "RST *", 0xe7, 8, 0, 0x20 },
  { "RST *", 0xef, 8, 0, 0x28 },
  { "RST *", 0xf7, 8, 0, 0x30 },
  { "RST *", 0xff, 8, 0, 0x38 },
  { "RST", 0xc7, 0, 0, 0 },

  { "SBC A,A", 0x9f, 0, 0, 0 },
  { "SBC A,B", 0x98, 0, 0, 0 },
  { "SBC A,C", 0x99, 0, 0, 0 },
  { "SBC A,D", 0x9a, 0, 0, 0 },
  { "SBC A,E", 0x9b, 0, 0, 0 },
  { "SBC A,H", 0x9c, 0, 0, 0 },
  { "SBC A,(HL)", 0x9e, 0, 0, 0 },
  { "SBC A,IXH", 0x9cdd, 3, 0, 0 },
  { "SBC A,IXL", 0x9ddd, 3, 0, 0 },
  { "SBC A,(IXs)", 0x9edd, 4, 0, 0 },
  { "SBC A,IYH", 0x9cfd, 3, 0, 0 },
  { "SBC A,IYL", 0x9dfd, 3, 0, 0 },
  { "SBC A,(IYs)", 0x9efd, 4, 0, 0 },
  { "SBC A,L", 0x9d, 0, 0, 0 },
  { "SBC A,x", 0xde, 1, 0, 0 },
  { "SBC HL,BC", 0x42ed, 3, 0, 0 },
  { "SBC HL,DE", 0x52ed, 3, 0, 0 },
  { "SBC HL,HL", 0x62ed, 3, 0, 0 },
  { "SBC HL,SP", 0x72ed, 3, 0, 0 },

  { "SCF", 0x37, 0, 0, 0 },

  { "SET *,A", 0xc7cb, 9, 0, 0 },
  { "SET *,B", 0xc0cb, 9, 0, 0 },
  { "SET *,C", 0xc1cb, 9, 0, 0 },
  { "SET *,D", 0xc2cb, 9, 0, 0 },
  { "SET *,E", 0xc3cb, 9, 0, 0 },
  { "SET *,H", 0xc4cb, 9, 0, 0 },
  { "SET *,(HL)", 0xc6cb, 9, 0, 0 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xc6, 0 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xc6, 0 },
  { "SET *,L", 0xc5cb, 9, 0, 0 },
  { "SET *,A", 0xcfcb, 9, 0, 1 },
  { "SET *,B", 0xc8cb, 9, 0, 1 },
  { "SET *,C", 0xc9cb, 9, 0, 1 },
  { "SET *,D", 0xcacb, 9, 0, 1 },
  { "SET *,E", 0xcbcb, 9, 0, 1 },
  { "SET *,H", 0xcccb, 9, 0, 1 },
  { "SET *,(HL)", 0xcecb, 9, 0, 1 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xce, 1 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xce, 1 },
  { "SET *,L", 0xcdcb, 9, 0, 1 },
  { "SET *,A", 0xd7cb, 9, 0, 2 },
  { "SET *,B", 0xd0cb, 9, 0, 2 },
  { "SET *,C", 0xd1cb, 9, 0, 2 },
  { "SET *,D", 0xd2cb, 9, 0, 2 },
  { "SET *,E", 0xd3cb, 9, 0, 2 },
  { "SET *,H", 0xd4cb, 9, 0, 2 },
  { "SET *,(HL)", 0xd6cb, 9, 0, 2 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xd6, 2 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xd6, 2 },
  { "SET *,L", 0xd5cb, 9, 0, 2 },
  { "SET *,A", 0xdfcb, 9, 0, 3 },
  { "SET *,B", 0xd8cb, 9, 0, 3 },
  { "SET *,C", 0xd9cb, 9, 0, 3 },
  { "SET *,D", 0xdacb, 9, 0, 3 },
  { "SET *,E", 0xdbcb, 9, 0, 3 },
  { "SET *,H", 0xdccb, 9, 0, 3 },
  { "SET *,(HL)", 0xdecb, 9, 0, 3 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xde, 3 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xde, 3 },
  { "SET *,L", 0xddcb, 9, 0, 3 },
  { "SET *,A", 0xe7cb, 9, 0, 4 },
  { "SET *,B", 0xe0cb, 9, 0, 4 },
  { "SET *,C", 0xe1cb, 9, 0, 4 },
  { "SET *,D", 0xe2cb, 9, 0, 4 },
  { "SET *,E", 0xe3cb, 9, 0, 4 },
  { "SET *,H", 0xe4cb, 9, 0, 4 },
  { "SET *,(HL)", 0xe6cb, 9, 0, 4 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xe6, 4 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xe6, 4 },
  { "SET *,L", 0xe5cb, 9, 0, 4 },
  { "SET *,A", 0xefcb, 9, 0, 5 },
  { "SET *,B", 0xe8cb, 9, 0, 5 },
  { "SET *,C", 0xe9cb, 9, 0, 5 },
  { "SET *,D", 0xeacb, 9, 0, 5 },
  { "SET *,E", 0xebcb, 9, 0, 5 },
  { "SET *,H", 0xeccb, 9, 0, 5 },
  { "SET *,(HL)", 0xeecb, 9, 0, 5 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xee, 5 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xee, 5 },
  { "SET *,L", 0xedcb, 9, 0, 5 },
  { "SET *,A", 0xf7cb, 9, 0, 6 },
  { "SET *,B", 0xf0cb, 9, 0, 6 },
  { "SET *,C", 0xf1cb, 9, 0, 6 },
  { "SET *,D", 0xf2cb, 9, 0, 6 },
  { "SET *,E", 0xf3cb, 9, 0, 6 },
  { "SET *,H", 0xf4cb, 9, 0, 6 },
  { "SET *,(HL)", 0xf6cb, 9, 0, 6 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xf6, 6 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xf6, 6 },
  { "SET *,L", 0xf5cb, 9, 0, 6 },
  { "SET *,A", 0xffcb, 9, 0, 7 },
  { "SET *,B", 0xf8cb, 9, 0, 7 },
  { "SET *,C", 0xf9cb, 9, 0, 7 },
  { "SET *,D", 0xfacb, 9, 0, 7 },
  { "SET *,E", 0xfbcb, 9, 0, 7 },
  { "SET *,H", 0xfccb, 9, 0, 7 },
  { "SET *,(HL)", 0xfecb, 9, 0, 7 },
  { "SET *,(IXs)", 0xcbdd, 10, 0xfe, 7 },
  { "SET *,(IYs)", 0xcbfd, 10, 0xfe, 7 },
  { "SET *,L", 0xfdcb, 9, 0, 7 },

  { "SLA A", 0x27cb, 3, 0, 0 },
  { "SLA B", 0x20cb, 3, 0, 0 },
  { "SLA C", 0x21cb, 3, 0, 0 },
  { "SLA D", 0x22cb, 3, 0, 0 },
  { "SLA E", 0x23cb, 3, 0, 0 },
  { "SLA H", 0x24cb, 3, 0, 0 },
  { "SLA (HL)", 0x26cb, 3, 0, 0 },
  { "SLA (IXs)", 0xcbdd, 5, 0x26, 0 },
  { "SLA (IYs)", 0xcbfd, 5, 0x26, 0 },
  { "SLA L", 0x25cb, 3, 0, 0 },

  { "SLL A", 0x37cb, 3, 0, 0 },
  { "SLL B", 0x30cb, 3, 0, 0 },
  { "SLL C", 0x31cb, 3, 0, 0 },
  { "SLL D", 0x32cb, 3, 0, 0 },
  { "SLL E", 0x33cb, 3, 0, 0 },
  { "SLL H", 0x34cb, 3, 0, 0 },
  { "SLL (HL)", 0x36cb, 3, 0, 0 },
  { "SLL (IXs)", 0xcbdd, 5, 0x36, 0 },
  { "SLL (IYs)", 0xcbfd, 5, 0x36, 0 },
  { "SLL L", 0x35cb, 3, 0, 0 },

  { "SRA A", 0x2fcb, 3, 0, 0 },
  { "SRA B", 0x28cb, 3, 0, 0 },
  { "SRA C", 0x29cb, 3, 0, 0 },
  { "SRA D", 0x2acb, 3, 0, 0 },
  { "SRA E", 0x2bcb, 3, 0, 0 },
  { "SRA H", 0x2ccb, 3, 0, 0 },
  { "SRA (HL)", 0x2ecb, 3, 0, 0 },
  { "SRA (IXs)", 0xcbdd, 5, 0x2e, 0 },
  { "SRA (IYs)", 0xcbfd, 5, 0x2e, 0 },
  { "SRA L", 0x2dcb, 3, 0, 0 },

  { "SRL A", 0x3fcb, 3, 0, 0 },
  { "SRL B", 0x38cb, 3, 0, 0 },
  { "SRL C", 0x39cb, 3, 0, 0 },
  { "SRL D", 0x3acb, 3, 0, 0 },
  { "SRL E", 0x3bcb, 3, 0, 0 },
  { "SRL H", 0x3ccb, 3, 0, 0 },
  { "SRL (HL)", 0x3ecb, 3, 0, 0 },
  { "SRL (IXs)", 0xcbdd, 5, 0x3e, 0 },
  { "SRL (IYs)", 0xcbfd, 5, 0x3e, 0 },
  { "SRL L", 0x3dcb, 3, 0, 0 },

  { "SUB A,IXH", 0x94dd, 3, 0, 0 },
  { "SUB A,IXL", 0x95dd, 3, 0, 0 },
  { "SUB (IXs)", 0x96dd, 4, 0, 0 },
  { "SUB A", 0x97, 0, 0, 0 },
  { "SUB B", 0x90, 0, 0, 0 },
  { "SUB C", 0x91, 0, 0, 0 },
  { "SUB D", 0x92, 0, 0, 0 },
  { "SUB E", 0x93, 0, 0, 0 },
  { "SUB H", 0x94, 0, 0, 0 },
  { "SUB (HL)", 0x96, 0, 0, 0 },
  { "SUB IYH", 0x94fd, 3, 0, 0 },
  { "SUB IYL", 0x95fd, 3, 0, 0 },
  { "SUB (IYs)", 0x96fd, 4, 0, 0 },
  { "SUB L", 0x95, 0, 0, 0 },
  { "SUB x", 0xd6, 1, 0, 0 },

  { "XOR A", 0xaf, 0, 0, 0 },
  { "XOR B", 0xa8, 0, 0, 0 },
  { "XOR C", 0xa9, 0, 0, 0 },
  { "XOR D", 0xaa, 0, 0, 0 },
  { "XOR E", 0xab, 0, 0, 0 },
  { "XOR H", 0xac, 0, 0, 0 },
  { "XOR (HL)", 0xae, 0, 0, 0 },
  { "XOR IXH", 0xacdd, 3, 0, 0 },
  { "XOR IXL", 0xaddd, 3, 0, 0 },
  { "XOR (IXs)", 0xaedd, 4, 0, 0 },
  { "XOR IYH", 0xacfd, 3, 0, 0 },
  { "XOR IYL", 0xadfd, 3, 0, 0 },
  { "XOR (IYs)", 0xaefd, 4, 0, 0 },
  { "XOR L", 0xad, 0, 0, 0 },
  { "XOR x", 0xee, 1, 0, 0 },

  { "E", 0x100, -1, 0, 0 }
};
